#include <stdio.h>

#define MAX_STUDENTS 20 // Maximum number of students

// Structure to store student information
struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents;

    // Input number of students (more than 10)
    do {
        printf("Enter the number of students (more than 10): ");
        scanf("%d", &numStudents);
    } while (numStudents <= 10 || numStudents > MAX_STUDENTS);

    // Input student information
    printf("Enter information for %d students:\n", numStudents);
    for (int i = 0; i < numStudents; i++) {
        printf("Student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);
        printf("Name: ");
        scanf("%s", students[i].name);
        printf("Age (between 18 to 24): ");
        scanf("%d", &students[i].age);
        while (students[i].age < 18 || students[i].age > 24) {
            printf("Invalid age. Age must be between 18 to 24. Please enter again: ");
            scanf("%d", &students[i].age);
        }
        printf("Address: ");
        scanf("%s", students[i].address);
    }

    // Input ID to display student details
    int searchId;
    printf("Enter the ID of the student whose details you want to view: ");
    scanf("%d", &searchId);

    // Search for the student with the given ID
    int found = 0;
    for (int i = 0; i < numStudents; i++) {
        if (students[i].id == searchId) {
            printf("Student Details:\n");
            printf("ID: %d\n", students[i].id);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            found = 1;
            break;
        }
    }

    if (!found) {
        printf("Student with ID %d not found.\n", searchId);
    }

    return 0;
}
